<?php
/**
 * Theme Social Share Widget
 * @package Bizmaster
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); //exit if access directly
}
// Control core classes for avoid errors
if (class_exists('CSF')) {


    // Create a About Widget
    CSF::createWidget('bizmaster_social_share_widget', array(
        'title' => esc_html__('Bizmaster: Social Share', 'bizmaster-core'),
        'classname' => 'bizmaster-social-share-about',
        'description' => esc_html__('Display Social Share widget', 'bizmaster-core'),
        'fields' => array(
            array(
                'id' => 'heading',
                'type' => 'text',
                'title' => esc_html__('Enter Your Header Title', 'bizmaster-core'),
                'default' => esc_html__('Never Miss News', 'bizmaster-core')
            ),
            array(
                'id' => 'bizmaster-social-icon-repeater',
                'type' => 'repeater',
                'title' => esc_html__('Social Icon', 'bizmaster-core'),
                'fields' => array(
                    array(
                        'id' => 'bizmaster-social-icon',
                        'type' => 'icon',
                        'title' => esc_html__('Icon', 'bizmaster-core'),
                        'default' => 'fab fa-facebook'
                    ),
                    array(
                        'id' => 'bizmaster-social-text',
                        'type' => 'text',
                        'title' => esc_html__('Enter Your Ulr', 'bizmaster-core'),
                        'default' => '#'
                    ),
                ),
            ),
        )
    ));


    if (!function_exists('bizmaster_social_share_widget')) {
        function bizmaster_social_share_widget($args, $instance)
        {

            echo $args['before_widget'];
            

            $heading_title = $instance['heading'] ?? '';
            $socialIcon = is_array($instance['bizmaster-social-icon-repeater']) && !empty($instance['bizmaster-social-icon-repeater']) ? $instance['bizmaster-social-icon-repeater'] : [];


            ?>
            <div class="social-share-widget">
                <h4 class="widget-headline"><?php echo esc_html($heading_title); ?></h4>
                <ul class="social-icon style-03">
                    <?php
                    foreach ($socialIcon as $icon) {
                        printf('<li><a href="%2$s"><i class="%1$s"></i></a></li>', esc_html($icon['bizmaster-social-icon']), esc_url($icon['bizmaster-social-text']));
                    };
                    ?>
                </ul>
            </div>

            <?php

            echo $args['after_widget'];

        }
    }

}

?>