<?php
/**
 * Theme Contact Info Widget
 * @package Bizmaster
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); //exit if access directly
}
// Control core classes for avoid errors
if (class_exists('CSF')) {


    // Create a Contact Info Widget
    CSF::createWidget('bizmaster_contact_info_widget', array(
        'title' => esc_html__('Bizmaster: Contact Info', 'bizmaster-core'),
        'classname' => 'bizmaster-widget-contact-info',
        'description' => esc_html__('Display Contact Info widget', 'bizmaster-core'),
        'fields' => array(
            array(
                'id' => 'title',
                'type' => 'text',
                'title' => esc_html__('Title', 'bizmaster-core'),
            ),
            array(
                'id' => 'location',
                'type' => 'textarea',
                'title' => esc_html__('Location', 'Bizmaster-core'),
                'default' => esc_html__('4517 Washington Ave. Manchester, Kentucky 39495', 'bizmaster-core'),
            ),
            array(
                'id' => 'phone',
                'type' => 'text',
                'title' => esc_html__('Phone', 'Bizmaster-core'),
                'default' => esc_html__(' (+888) 123 456 765', 'bizmaster-core'),
            ),
            array(
                'id' => 'email',
                'type' => 'text',
                'title' => esc_html__('Email', 'Bizmaster-core'),
                'default' => esc_html__(' infoname@mail.com', 'bizmaster-core'),
            ),
            array(
                'id' => 'open_time',
                'type' => 'text',
                'title' => esc_html__('Open Time', 'Bizmaster-core'),
                'default' => esc_html__('We are open from Monday to Friday 09.00 AM - 17.00 PM', 'bizmaster-core'),
            ),

            array(
                'id' => 'bizmaster-footer-social-icon-repeater',
                'type' => 'repeater',
                'title' => esc_html__('Social Icon', 'bizmaster-core'),
                'fields' => array(

                    array(
                        'id' => 'bizmaster-footer-social-icon',
                        'type' => 'icon',
                        'title' => esc_html__('Icon', 'bizmaster-core'),
                        'default' => 'flaticon-call'
                    ),
                    array(
                        'id' => 'bizmaster-footer-social-text',
                        'type' => 'text',
                        'title' => esc_html__('Enter Your Url', 'bizmaster-core'),
                        'default' => esc_html__('#', 'bizmaster-core')
                    ),

                ),
            ),
        )
    ));


    if (!function_exists('bizmaster_contact_info_widget')) {
        function bizmaster_contact_info_widget($args, $instance)
        {

            echo $args['before_widget'];
            $title = $instance['title'] ?? '';
            $location = $instance['location'] ?? '';
            $phone = $instance['phone'] ?? '';
            $email = $instance['email'] ?? '';
            $open_time = $instance['open_time'] ?? '';
            $csocialIcon = is_array($instance['bizmaster-footer-social-icon-repeater']) && !empty($instance['bizmaster-footer-social-icon-repeater']) ? $instance['bizmaster-footer-social-icon-repeater'] : [];
            ?>

            <div class="footer-widget widget">
            	<h4 class="widget-headline"><?php echo esc_html($title); ?></h4>
            	<div class="widget_contact">
                    <ul class="details">
                        <?php if($phone) : ?>
                            <li class="mt-3 text-white2"><i class="fa fa-phone-alt text-green"></i> <?php echo esc_html($phone); ?></li>
                        <?php endif; ?>
                        <li class="mt-2 text-white2"><i class="fas fa-envelope text-green"></i> <?php echo esc_html($email); ?></li>
                        <li class="text-white2"><i class="fa fa-map-marker-alt text-green"></i><?php echo esc_html($location); ?></li>
                        <?php if($open_time) : ?>
                            <li class="color-base fw-600">Open Hour</li>
                            <li class="text-white2"><?php echo esc_html($open_time); ?></li>
                        <?php endif; ?>
                    </ul>
                    <?php if (!empty($csocialIcon)) { ?>
                        <ul class="social-media mt-4">
                            <?php
                            foreach ($csocialIcon as $cicon) {
                                echo '<li>
	                                <a href="'.$cicon['bizmaster-footer-social-text'].'">
	                                    <i class="'. $cicon['bizmaster-footer-social-icon'] . '"></i></a>
	                            </li>';
                            };
                            ?>
                        </ul>
                    <?php } ?>
                </div>
            </div>

            <?php

            echo $args['after_widget'];

        }
    }

}

?>