<?php
/**
 * Elementor Widget
 * @package bizmaster
 * @since 1.0.0
 */

namespace Elementor;

class Bizmaster_Testimonial_Slider_One_Two_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'bizmaster-testimonial-slider-two';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Testimonial Slider Two', 'bizmaster-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slides';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['bizmaster_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {
		$this->start_controls_section(
			'slider_settings_section',
			[
				'label' => esc_html__('Slider Settings', 'bizmaster-core'),
				'tab' => Controls_Manager::TAB_CONTENT
			]
		);

		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'image', [
				'label' => esc_html__('Main Image', 'bizmaster-core'),
				'type' => Controls_Manager::MEDIA,
				'show_label' => false,
				'description' => esc_html__('Upload Main Image', 'bizmaster-core')
			]
		);

		$repeater->add_control(
			'icon',
			[
				'label' => esc_html__('Icon', 'bizmaster-core'),
				'type' => Controls_Manager::ICONS,
				'description' => esc_html__('Upload Icon', 'bizmaster-core'),
				'default' => [
					'value' => 'fas fa-quote-right',
					'library' => 'solid'
				]
			]
		);

		$repeater->add_control(
			'content', [
				'label' => esc_html__('Content', 'bizmaster-core'),
				'type' => Controls_Manager::TEXTAREA,
				'show_label' => false,
				'default' => esc_html__('Lorem Ipsum is simply dummy text of the printing and typesetting industry. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.'),
				'description' => esc_html__('Upload Content', 'bizmaster-core')
			]
		);

		$repeater->add_control(
			'name', [
			'label' => esc_html__('Name', 'bizmaster-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Jhon Suria', 'bizmaster-core'),
				'show_label' => true,
				'description' => esc_html__('enter name', 'bizmaster-core')
			]
		);

		$repeater->add_control(
			'designation', [
				'label' => esc_html__('Designation', 'bizmaster-core'),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__('Marketing Coordinator', 'bizmaster-core'),
				'description' => esc_html__('enter designation', 'bizmaster-core')
			]
		);

		$this->add_control('testimonial_items', [
			'label' => esc_html__('Testimonial Slider Item', 'bizmaster-core'),
			'type' => Controls_Manager::REPEATER,
			'fields' => $repeater->get_controls(),
			'default' => [
				[
					'image' => array('url' => Utils::get_placeholder_image_src())
				]
			]
		]);

		$this->end_controls_section();

		$this->start_controls_section(
			'slider_control_section',
			[
				'label' => esc_html__('Slider Settings', 'bizmaster-core'),
				'tab' => Controls_Manager::TAB_CONTENT
			]
		);

		$this->add_control(
            'loop',
            [
                'label' => esc_html__('Loop', 'bizmaster-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'bizmaster-core'),
            ]
        );

		$this->add_control(
            'center',
            [
                'label' => esc_html__('Center', 'bizmaster-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'bizmaster-core'),

            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('Autoplay', 'bizmaster-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes/no to enable/disable', 'bizmaster-core'),
            ]
        );

        $this->add_control(
            'autoplaytimeout',
            [
                'label' => esc_html__('Autoplay Timeout', 'bizmaster-core'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 500,
                        'max' => 10000,
                        'step' => 100,
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 5000,
                ],
                'size_units' => ['px'],
                'condition' => array(
                    'autoplay' => 'yes'
                )
            ]
        );

		$this->add_control(
			'nav',
			[
				'label' => esc_html__('Nav', 'bizmaster-core'),
				'type' => Controls_Manager::SWITCHER,
				'description' => esc_html__('you can set yes/no to enable/disable', 'bizmaster-core'),
				'default' => 'yes'
			]
		);

		$this->add_control(
			'nav_left_arrow',
			[
				'label' => esc_html__('Nav Left Icon', 'bizmaster-core'),
				'type' => Controls_Manager::ICONS,
				'description' => esc_html__('upload the nav left icon', 'bizmaster-core'),
				'default' => [
					'value' => 'fas fa-angle-left',
					'library' => 'solid'
				],
				'condition' => ['nav' => 'yes']
			]
		);

		$this->add_control(
            'nav_right_arrow',
            [
                'label' => esc_html__('Nav Right Icon', 'bizmaster-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('upload the nav right icon', 'bizmaster-core'),
				'default' => [
					'value' => 'fas fa-angle-right',
					'library' => 'solid'
				],
				'condition' => ['nav' => 'yes']
			]
		);

        $this->end_controls_section();

		$this->start_controls_section(
            'testimonial_two_styling_settings_section',
            [
                'label' => esc_html__('Styling Settings', 'bizmaster-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_control('quote_icon_bg_color', [
			'label' => esc_html__('Quote Icon BG Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .testi-box .quote-icon" => "background: {{VALUE}}"
			]
		]);

		$this->add_control('quote_icon_color', [
			'label' => esc_html__('Quote Icon Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .testi-box .quote-icon i" => "color: {{VALUE}};",
				"{{WRAPPER}} .testi-box .quote-icon svg" => "color: {{VALUE}}; fill: {{VALUE}}"
			]
		]);

		$this->add_control('content_color', [
			'label' => esc_html__('Content Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .testi-box .testi-box_content .testi-box_text" => "color: {{VALUE}}"
			]
		]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
			'label' => esc_html__('Content Typography', 'bizmaster-core'),
			'name' => 'content_typography',
			'description' => esc_html__('Content Typography', 'bizmaster-core'),
			'selector' => "{{WRAPPER}} .testi-box .testi-box_content .testi-box_text"
		]);

		$this->add_control('name_color', [
			'label' => esc_html__('Name Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .testi-box .testi-box_content .testi-box-profile .testi-profile-title" => "color: {{VALUE}}"
			]
		]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
			'label' => esc_html__('Name Typography', 'bizmaster-core'),
			'name' => 'name_typography',
			'description' => esc_html__('Name Typography', 'bizmaster-core'),
			'selector' => "{{WRAPPER}} .testi-box .testi-box_content .testi-box-profile .testi-profile-title"
		]);

		$this->add_control('designation_color', [
			'label' => esc_html__('Designation Color', 'bizmaster-core'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				"{{WRAPPER}} .testi-box .testi-box_content .testi-box-profile .testi-profile-desig" => "color: {{VALUE}}"
			]
		]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
			'label' => esc_html__('Designation Typography', 'bizmaster-core'),
			'name' => 'designation_typography',
			'description' => esc_html__('Designation Typography', 'bizmaster-core'),
			'selector' => "{{WRAPPER}} .testi-box .testi-box_content .testi-box-profile .testi-profile-desig"
		]);

		$this->add_control(
			'testi_image_border_radius',
			[
				'label'      => esc_html__('Image Border Radius', 'bizmaster-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .testi-box .testi-box_content .testi-box-profile .testi-profile_thumb img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control('nav_icons_bg_color', [
            'label' => esc_html__('Navigation Icons BG Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .testimonial-area-2.arrow-wrap .slick-arrow" => "background: {{VALUE}}"
            ]
        ]);

        $this->add_control('nav_icon_color', [
            'label' => esc_html__('Navigation Icon Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .testimonial-area-2.arrow-wrap .slick-arrow" => "color: {{VALUE}}; fill: {{VALUE}}",
            ]
        ]);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'testimonial_slider_two_border',
				'label'    => esc_html__('Border', 'bizmaster-core'),
				'selector' => '{{WRAPPER}} .testimonial-area-2.arrow-wrap .slick-arrow'
			]
		);

		$this->add_control('nav_icons_bg_hover_color', [
            'label' => esc_html__('Navigation Icons BG Hover Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .testimonial-area-2.arrow-wrap .slick-arrow:hover" => "background: {{VALUE}}"
            ]
        ]);

        $this->add_control('nav_icon_hover_color', [
            'label' => esc_html__('Navigation Icon Hover Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .testimonial-area-2.arrow-wrap .slick-arrow:hover" => "color: {{VALUE}}; fill: {{VALUE}}",
            ]
        ]);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'testimonial_slider_two_hover_border',
				'label'    => esc_html__('Border', 'bizmaster-core'),
				'selector' => '{{WRAPPER}} .testimonial-area-2.arrow-wrap .slick-arrow:hover'
			]
		);

		$this->end_controls_section();
	}

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render() {

		$settings = $this->get_settings_for_display();
		$all_testimonial_items = $settings['testimonial_items'];
		$rand_numb = rand(333, 999999999);

		//slider settings
		$slider_settings = [
			"loop" => esc_attr($settings['loop']),
			"items" => 1,
			"center" => esc_attr($settings['center']),
			"autoplay" => esc_attr($settings['autoplay']),
			"autoplaytimeout" => esc_attr(!empty($settings['autoplaytimeout']['size']) ? $settings['autoplaytimeout']['size'] : 0),
			"nav" => esc_attr($settings['nav']),
			"navleft" => bizmaster_core()->render_elementor_icons($settings['nav_left_arrow']),
			"navright" => bizmaster_core()->render_elementor_icons($settings['nav_right_arrow'])
		];
		?>
		<div class="testimonial-area-2 arrow-wrap">
			<div class="testiomonial-wrap-2">
				<div class="row slider-shadow testi-slider-2" id="testimonial-slider-two-carousel-<?php echo esc_attr($rand_numb); ?>" data-settings='<?php echo json_encode($slider_settings) ?>'>
					<?php foreach ($all_testimonial_items as $testimonial_item): ?>
						<div class="testi-box">
							<div class="quote-icon">
								<?php echo bizmaster_core()->render_elementor_icons($testimonial_item['icon']); ?>
							</div>
							<div class="testi-box_content">
								<p class="testi-box_text"><?php echo esc_html($testimonial_item['content']); ?></p>
								<div class="testi-box-profile">
									<div class="testi-box-profile-details mb-3">
										<h4 class="testi-profile-title"><?php echo esc_html($testimonial_item['name']); ?></h4>
										<span class="testi-profile-desig"><?php echo esc_html($testimonial_item['designation']); ?></span>
									</div>
									<div class="testi-profile_thumb">
										<img src="<?php echo $testimonial_item['image']['url']; ?>" alt="img">
									</div>
								</div>
							</div>
						</div>
					<?php endforeach; ?>
				</div>
				<?php if (!empty($settings['nav'])) : ?>
					<div class="slick-carousel-controls nav-wrapper">
						<div class="slider-nav"></div>
					</div>
				<?php endif; ?>
			</div>
		</div>
		<?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type(new Bizmaster_Testimonial_Slider_One_Two_Widget());
