<?php
/**
 * Elementor Widget
 * @package Bizmaster
 * @since 1.0.0
 */

namespace Elementor;
class Bizmaster_Service_Category_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'bizmaster-service-category-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Service Category', 'bizmaster-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slider-album';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['bizmaster_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {
		$this->start_controls_section(
            'service_categories_styling_settings_section',
            [
                'label' => esc_html__('Styling Settings', 'bizmaster-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_control('service_category_widget_bg_color', [
            'label' => esc_html__('Widget BG Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .widget_service-categories" => "background: {{VALUE}}"
            ]
        ]);

		$this->add_control(
			'service_category_widget_border_radius',
			[
				'label'      => esc_html__('Widget Border Radius', 'bizmaster-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .widget_service-categories' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control('service_category_bg_color', [
            'label' => esc_html__('Category BG Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .widget_service-categories ul li a" => "background: {{VALUE}}"
            ]
        ]);

		$this->add_control('service_category_bg_hover_color', [
            'label' => esc_html__('Category BG Hover Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .widget_service-categories ul li a:hover" => "background: {{VALUE}}"
            ]
        ]);

		$this->add_control('service_category_color', [
            'label' => esc_html__('Category Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .widget_service-categories ul li a" => "color: {{VALUE}}"
            ]
        ]);

		$this->add_control('service_category_hover_color', [
            'label' => esc_html__('Category Hover Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .widget_service-categories ul li a:hover" => "color: {{VALUE}}"
            ]
        ]);

		$this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Category Typography', 'bizmaster-core'),
            'name' => 'service_category_typography',
            'description' => esc_html__('Category Typography', 'bizmaster-core'),
            'selector' => "{{WRAPPER}} .widget_service-categories ul li a"
        ]);

		$this->add_control(
			'service_category_border_radius',
			[
				'label'      => esc_html__('Category Border Radius', 'bizmaster-core'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .widget_service-categories ul li a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
	}

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render() {

		$settings = $this->get_settings_for_display(); ?>
        <aside class="sidebar-area service-sitebar">  
            <div class="widget widget_categories widget_service-categories">  
                <ul>
                    <?php
						$taxonomy = 'service-category';
						$terms = get_terms($taxonomy);
						if ( $terms && !is_wp_error( $terms ) ) :
							foreach ( $terms as $term ) {
								$term_name = $term->name;
								$term_name_slug = str_replace(' ', '', $term_name);
								$term_link = get_term_link( $term );
							?>
							<li>
								<a href="<?php echo $term_link; ?>"><?php echo $term->name; ?></a>
							</li>
						<?php } ?>
					<?php endif; ?>
				</ul>
            </div>
        </aside>
		<?php
	}
}

Plugin::instance()->widgets_manager->register_widget_type(new Bizmaster_Service_Category_Widget());
