<?php
/**
 * Elementor Widget
 * @package Bizmaster
 * @since 1.0.0
 */

namespace Elementor;
class Bizmaster_Banner_Three_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'bizmaster-theme-banner-three-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Banner three', 'bizmaster-core');
    }

    public function get_keywords()
    {
        return ['Section', 'Banner', 'Title', "HugeBinary", 'Bizmaster'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-banner';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['bizmaster_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'banner_two_content_settings_section',
            [
                'label' => esc_html__('Content Settings', 'bizmaster-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'subtitle',
            [
                'label' => esc_html__('sub Title', 'bizmaster-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Growth Accel erato', 'bizmaster-core'),
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'bizmaster-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Your Growth Catalyst Our Expertise', 'bizmaster-core'),
            ]
        );

        $this->add_control(
            'content',
            [
                'label' => esc_html__('content', 'bizmaster-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('A business consultant is a professional who provides expert advice and guidance to businesses', 'bizmaster-core'),
            ]
        );

        $this->add_control(
            'image', [
                'label' => esc_html__('Image', 'bizmaster-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload Main Image', 'bizmaster-core'),
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                )
            ]
        );

        $this->add_control(
            'left_icon', [
                'label' => esc_html__('Left Icon', 'bizmaster-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('Upload Left Icon', 'bizmaster-core')
            ]
        );

        $this->add_control(
            'left_title',
            [
                'label' => esc_html__('Left Title', 'bizmaster-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Growth Acceler', 'bizmaster-core'),
            ]
        );

        $this->add_control(
            'left_content',
            [
                'label' => esc_html__('Left Content', 'bizmaster-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('A business consultant', 'bizmaster-core'),
            ]
        );

        $this->add_control(
            'right_icon', [
                'label' => esc_html__('Right Icon', 'bizmaster-core'),
                'type' => Controls_Manager::MEDIA,
                'show_label' => false,
                'description' => esc_html__('right Icon', 'bizmaster-core')
            ]
        );

        $this->add_control(
            'right_title',
            [
                'label' => esc_html__('Right Title', 'bizmaster-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Need help?', 'bizmaster-core'),
            ]
        );

        $this->add_control(
            'right_content',
            [
                'label' => esc_html__('Right Content', 'bizmaster-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('(319) 555-0115', 'bizmaster-core'),
            ]
        );

		$this->add_control(
            'right_content_url',
            [
                'label' => esc_html__('Right Content Url', 'bizmaster-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('tel:3195550115', 'bizmaster-core'),
            ]
        );

        $this->end_controls_section();

        /*  tab styling tabs start */
        $this->start_controls_section(
            'style_settings_section',
            [
                'label' => esc_html__('Style Settings', 'bizmaster-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control('subtitle_color', [
            'label' => esc_html__('subtitle Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .hero-style3 .sub-title" => "color: {{VALUE}}"
            ]
        ]);

        $this->add_control('title_action_color', [
            'label' => esc_html__('title action Color', 'bizmaster-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .hero-style3 .hero-title span" => "color: {{VALUE}}"
            ]
        ]);

        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('title action Typography', 'bizmaster-core'),
            'name' => 'title_action_typography',
            'description' => esc_html__('title action typography', 'bizmaster-core'),
            'selector' => "{{WRAPPER}} .hero-style3 .hero-title span"
        ]);

        $this->end_controls_section();
    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>

        <div class="hero-wrapper bg-smoke hero-3">
            <div class="container">
                <div class="row flex-row-reverse">
                    <div class="col-xl-6">
                        <div class="hero-image-wrapp">
                            <div class="hero-thumb text-center">
                                <img src="<?php echo $settings['image']['url']; ?>" alt="img">
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="hero-style3">
                            <span class="sub-title"><img src="<?php echo get_template_directory_uri() .'/assets/img/title_left.svg'; ?>" alt="shape"><?php echo $settings['subtitle']; ?></span>
                            <h1 class="hero-title"><?php echo $settings['title']; ?></h1>
                            <p class="hero-text"><?php echo $settings['content']; ?></p>
                            <div class="btn-wrap">
                                <div class="hero-card_wrapper">
                                    <div class="hero-card">
										<?php if(!empty($settings['left_icon']['url'])) { ?>
											<div class="hero-card_icon">
												<img src="<?php echo $settings['left_icon']['url']; ?>" alt="img">
											</div>
										<?php } ?>
                                        <div class="hero-card_content">
                                            <h4 class="box-title"><?php echo $settings['left_title']; ?></h4>
                                            <p class="hero-card_text"><?php echo $settings['left_content']; ?></p>
                                        </div>
                                    </div>
                                </div>
                                <div class="feature-wrapper">
									<?php if(!empty($settings['right_icon']['url'])) { ?>
										<div class="feature-icon">
											<a href="<?php echo $settings['right_content_url']; ?>"><img src="<?php echo $settings['right_icon']['url']; ?>" alt=""></a>
										</div>
									<?php } ?>
									<div class="media-body">
                                        <span class="header-info_label"><?php echo $settings['right_title']; ?></span>
                                        <p class="header-info_link"><a href="<?php echo $settings['right_content_url']; ?>"><?php echo $settings['right_content']; ?></a></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>                
                </div>
                
            </div>
        </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Bizmaster_Banner_Three_Widget());