<?php
/*
Plugin Name: Bizmaster Core
Plugin URI: https://themeforest.net/user/wpcodersthemes/portfolio
Description: Plugin to contain short codes and custom post types of the Bizmaster theme.
Author: wpcodersthemes
Author URI: https://themeforest.net/user/wpcodersthemes
Version: 1.0.4
Text Domain: bizmaster-core
Developer: Rajesh Bhaskar (rkbhaskar89@gmail.com)
*/


/**
 * If this file is called directly, abort.
 * @package bizmaster
 * @since 1.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Plugin directory path
 * @package bizmaster
 * @since 1.0.0
 */
define( 'BIZMASTER_CORE_ROOT_PATH', plugin_dir_path( __FILE__ ) );
define( 'BIZMASTER_CORE_ROOT_URL', plugin_dir_url( __FILE__ ) );
define( 'BIZMASTER_CORE_SELF_PATH', 'bizmaster-core/bizmaster-core.php' );
define( 'BIZMASTER_CORE_VERSION', '2.0.1' );
define( 'BIZMASTER_CORE_INC', BIZMASTER_CORE_ROOT_PATH .'/inc');
define( 'BIZMASTER_CORE_LIB', BIZMASTER_CORE_ROOT_PATH .'/lib');
define( 'BIZMASTER_CORE_ELEMENTOR', BIZMASTER_CORE_ROOT_PATH .'/elementor');
define( 'BIZMASTER_CORE_DEMO_IMPORT', BIZMASTER_CORE_ROOT_PATH .'/demo-import');
define( 'BIZMASTER_CORE_ADMIN', BIZMASTER_CORE_ROOT_PATH .'/admin');
define( 'BIZMASTER_CORE_ADMIN_ASSETS', BIZMASTER_CORE_ROOT_URL .'admin/assets');
define( 'BIZMASTER_CORE_WP_WIDGETS', BIZMASTER_CORE_ROOT_PATH .'/wp-widgets');
define( 'BIZMASTER_CORE_ASSETS', BIZMASTER_CORE_ROOT_URL .'assets/');
define( 'BIZMASTER_CORE_CSS', BIZMASTER_CORE_ASSETS .'css');
define( 'BIZMASTER_CORE_JS', BIZMASTER_CORE_ASSETS .'js');
define( 'BIZMASTER_CORE_IMG', BIZMASTER_CORE_ASSETS .'img');


/**
 * Load additional helpers functions
 * @package bizmaster
 * @since 1.0.0
 */
if (!function_exists('bizmaster_core')){
	require_once BIZMASTER_CORE_INC .'/theme-core-helper-functions.php';
	if (!function_exists('bizmaster_core')){
		function bizmaster_core(){
			return class_exists('Bizmaster_Core_Helper_Functions') ? new Bizmaster_Core_Helper_Functions() : false;
		}
	}
}
//ob flash
remove_action( 'shutdown', 'wp_ob_end_flush_all', 1 );


/**
 * Load Codestar Framework Functions
 * @package bizmaster
 * @since 1.0.0
 */
if ( !bizmaster_core()->is_bizmaster_active()) {
	if ( file_exists( BIZMASTER_CORE_ROOT_PATH . '/inc/csf-functions.php' ) ) {
		require_once BIZMASTER_CORE_ROOT_PATH . '/inc/csf-functions.php';
	}
}



/**
 * Core Plugin Init
 * @package bizmaster
 * @since 1.0.0
 */
if ( file_exists( BIZMASTER_CORE_ROOT_PATH . '/inc/theme-core-init.php' ) ) {
	require_once BIZMASTER_CORE_ROOT_PATH . '/inc/theme-core-init.php';
}